package cn.com.duiba.user.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.wxwork.WxWorkCorpDto;
import cn.com.duiba.user.service.api.dto.wxwork.WxWorkCorpSuiteDto;
import cn.com.duiba.user.service.api.param.wxwork.WxWorkAuthCorpSuiteParam;

import java.util.List;

/**
 * 第三方企微授权的应用操作接口
 * @author dugq
 * @date 2021/11/24 10:30 上午
 */
@AdvancedFeignClient
public interface RemoteWxWorkThirdCorpSuiteService {

    WxWorkCorpSuiteDto selectById(Long id);

    /**
     * 第三方企微授权服务商应用时，完成第三方企微账号和授权信息的初始化
     */
    Long initThirdCorpSuit(WxWorkAuthCorpSuiteParam param);


    /**
     * 取消授权
     * @return 0: 不存在 1：已取消 -1： 取消失败
     */
    Integer cancelThirdCorpSuit(String suitKey, String thirdCorpKey);

    /**
     * 查询第三方企微授权应用信息
     * @param suitKey 服务商应用的suitid
     * @param thirdCorpKey 授权方的corpid
     */
    WxWorkCorpSuiteDto selectThirdCorpSuitByKey(String suitKey, String thirdCorpKey);

    /**
     * 查询第三方企微授权应用信息
     * @param suitId 服务商应用的ID tb_suit表ID
     * @param thirdCorpId 授权方的ID tb_corp表ID
     */
    WxWorkCorpSuiteDto selectThirdCorpSuitById(Long suitId, Long thirdCorpId);

    /**
     * 查询授权指定应用的企业列表
     * @param suiteId 应用ID
     * @return 授权的企业列表
     */
    List<WxWorkCorpDto> selectBySuitId(Long suiteId);

    /**
     * 查询第三方企业授权的所有应用
     */
    List<WxWorkCorpSuiteDto> selectByThirdCorpId(Long thirdCorpId);
}
