package cn.com.duiba.user.service.api.remoteservice.wxworkuser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.wxworkuser.WxWorkUserDto;
import cn.com.duiba.user.service.api.dto.wxworkuser.UserWxWorkExtDto;
import cn.com.duiba.user.service.api.param.wxworkuser.SaveWxWorkMpUserParam;
import cn.com.duiba.user.service.api.param.wxworkuser.SaveWxWorkUserParam;

import java.util.List;
import java.util.Map;

/**
 * 企微用户操作
 * @author dugq
 * @date 2021/11/26 2:07 下午
 */
@AdvancedFeignClient
public interface RemoteWxWorkUserService {

    /**
     * 保存企微用户
     */
    Long saveCorpUser(SaveWxWorkUserParam saveWxWorkUserParam);

    /**
     * 保存企微小程序用户
     */
    Long saveCorpMpUser(SaveWxWorkMpUserParam saveWxWorkMpUserParam);

    /**
     * 查询用户小程序的sessionKey
     */
    String findMpSessionKeyByUserId(Long userId, Long oaId);

    /**
     * 根据用户ID查询企微用户信息
     */
    WxWorkUserDto selectByUserId(Long userId);
    /**
     * 根据用户ID查询企微用户扩展信息
     */
    UserWxWorkExtDto selectCorpExtByUserId(Long userId);

    /**
     * 根据用户企微账号查询企微用户信息
     */
    WxWorkUserDto selectByUserKey(String corpKey, String userKey);

    /**
     * 根据用户企微账号查询企微用户信息
     */
    UserWxWorkExtDto selectExtByUserKey(String corpKey, String userKey);

    /**
     * 更新用户sessionKey
     * @param userId 用户ID
     * @param oaId 小程序ID
     * @param sessionKey 用户在小程序sessionKey
     * @return >0 更新成功
     */
    int updateSessionKey(Long userId, Long oaId, String sessionKey);

    /**
     * 根据用户id批量查询
     *
     * @param userIds 用户id集合
     * @return 企微用户信息
     */
    List<UserWxWorkExtDto> selectByUserIds(List<Long> userIds);

    /**
     * 更新激活状态
     * @param id 主键id
     * @param activeStatus 激活状态 0-未激活 1-已激活
     * @return 更新结果
     */
    int updateActiveStatus(Long id, Integer activeStatus);

    /**
     * 批量更新激活状态
     *
     * @param id2ActiveStatus key: id value: 激活状态 0-未激活 1-已激活
     * @return 更新结果
     */
    int batchUpdateActiveStatus(Map<Long, Integer> id2ActiveStatus);

    /**
     * 根据corpId瀑布流查询用户
     *
     * @param corpId 企业id
     * @param lastId 上一轮的最大主键id
     * @param pageSize 每次查询数量
     * @return 用户信息
     */
    List<UserWxWorkExtDto> selectByCorpIdPage(Long corpId, Long lastId, Integer pageSize);
}
