package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息推送方式
 *
 * @author: liupu1
 * @create: 2020/8/14 3:47 PM
 **/
public enum AutoPushEnum {

    MANUAL_PUSH(0, "手动推送"),
    AUTO_PUSH(1, "自动推送");

    Integer code;
    String desc;

    AutoPushEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, AutoPushEnum> ENUM_MAP = new HashMap<>();

    static {
        for (AutoPushEnum pushEnum : values()) {
            ENUM_MAP.put(pushEnum.getCode(), pushEnum);
        }
    }

    public static AutoPushEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
