package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息推送周期
 *
 * @author: liupu1
 * @create: 2020/8/14 3:50 PM
 **/
public enum PushCycleEnum {

    ONCE(1, "单次推送"),
    DAILY(2, "每日推送"),
    WEEKLY(3, "每周推送"),
    MONTHLY(4, "每月推送");

    Integer code;
    String desc;

    PushCycleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, PushCycleEnum> ENUM_MAP = new HashMap<>();

    static {
        for (PushCycleEnum cycleEnum : values()) {
            ENUM_MAP.put(cycleEnum.getCode(), cycleEnum);
        }
    }

    public static PushCycleEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
