package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息推送范围
 * @author: liupu1
 * @create: 2020/8/14 3:42 PM
 **/
public enum PushScopeEnum {

    ALL_SCOPE(0,"全量推送"),
    PATITION_SCOPE(1,"部分推送");

    int code;
    String desc;

    PushScopeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    private static final Map<Integer, PushScopeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (PushScopeEnum cycleEnum : values()) {
            ENUM_MAP.put(cycleEnum.getCode(), cycleEnum);
        }
    }

    public static PushScopeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
