package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.MpUserinfoDto;
import cn.com.duiba.wechat.server.api.enums.SubscribeEnum;

/**
 * @author chengsiyi
 * @date 2019/6/15 16:47
 */
@AdvancedFeignClient
public interface RemoteMpService {

    /**
     * 获取公众号下用户信息
     *
     * @param wechatAppId 微信公众号ID
     * @param openId      用户openID
     * @return 用户信息,可能返回null
     */
    @Deprecated
    MpUserinfoDto getUserinfo(String wechatAppId, String openId);

    /**
     * 获取公众号授权APP下用户信息
     * @param appId 兑吧appID
     * @param consumerId 兑吧consumerID
     * @return 用户信息,可能返回null
     * @see RemoteMpService#getUserInfo(Long)
     */
    @Deprecated
    MpUserinfoDto getUserinfoByDuibaApp(Long appId, Long consumerId);

    /**
     * 获取公众号授权APP下用户信息
     *
     * @param consumerId 兑吧consumerID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoDto getUserInfo(Long consumerId);

    /**
     * 查询用户绑定的openId
     * <p>
     * 该接口适用于从wechat授权登录的用户，在业务中绑定了手机号，然后用手机号作为uid进行免登
     *
     * @param consumerId 用户ID
     * @return openId 可能返回null
     */
    String getBindOpenId(Long consumerId);

    /**
     * 获取用户关注状态
     * @param consumerId
     * @return 关注状态
     * @throws BizException
     */
    SubscribeEnum getSubscribeStatus(Long consumerId) throws BizException;

}
