package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WeOrderDto;
import cn.com.duiba.wechat.server.api.dto.WeUserDto;
import cn.com.duiba.wechat.server.api.param.WeOrderParam;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2020/1/11 17:43
 */
@AdvancedFeignClient
public interface RemoteWeUserService {

    /**
     * 新增或者查找用户
     * @param appKey appKey
     * @param uid 用户uid
     * @param initCredits 初始化积分数，仅在新增有效
     * @return
     */
    WeUserDto findOrInsertUser(String appKey, String uid, Long initCredits);


	/**
	 * 更新用户openId 和对应订单记录的openId
	 * @param appKey appKey
	 * @param oldOpenId 旧openId
	 * @param newOpenId 新openId
	 * @return
	 */
	Integer updateWeUser(String appKey, String oldOpenId, String newOpenId);


	/**
	 * 查询weUser
	 * @param appKey appKey
	 * @param openId openId
	 * @return
	 */
	WeUserDto findByOpenIdAndAppKey(String appKey, String openId);

	/**
	 * 获取用户积分记录列表
	 * @param param
	 * @return
	 */
	List<WeOrderDto> listByOpenId(WeOrderParam param);
}
