package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wechat.server.api.dto.WxCustomerMsgConfigDto;
import cn.com.duiba.wechat.server.api.param.WxConsumerDirectPushParam;

import java.util.List;


/**
 * @author zdq
 * @Description 微信客服消息接口
 * @createTime 2020年09月27日 16:11:00
 */
public interface RemoteWxConsumerMsgService {

    /**
     * 全量推送
     *
     * @param dto
     * @param appKey
     * @param pushId 模板消息配置主键
     * @throws BizException
     */

    void fullPush(WxCustomerMsgConfigDto dto, String appKey, Long pushId) throws BizException;


    /**
     * 定向推送
     *
     * @param dto
     * @param param
     * @param appKey
     * @param pushId 模板消息配置主键
     * @throws BizException
     */
    void directPush(WxCustomerMsgConfigDto dto, WxConsumerDirectPushParam param, String appKey, Long pushId) throws BizException;

    /**
     * 根据模板id和openid推送
     *
     * @param id 客服消息配置 id
     * @param openIds
     * @param pushId 模板消息主键id （可传null，为null时，客服消息推送失败不会降级发模板消息）
     * @return
     */
    boolean pushConsumerMsgByOpenIds(Long id, Long pushId, List<String> openIds) throws BizException;


}
