package cn.com.duiba.wechat.server.api.remoteservice;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WeAppDto;
import cn.com.duiba.wechat.server.api.dto.WxAuthorizerAccessTokenDto;
import cn.com.duiba.wechat.server.api.dto.WxAuthorizerDto;

/**
 * @author zdq
 * @Description  授权相关接口
 * @createTime 2020年05月12日 16:49:00
 */
@AdvancedFeignClient
public interface RemoteWxThirdPartyService {


    /**
     * 微信授权事件接收url - 微信推送
     *
     * @return
     * @throws BizException
     */
    String receiveTicketPush(String msg_signature, String timestamp, String nonce, String postdata) throws BizException;


    String getComponentAccessToken() throws BizException;


    WxAuthorizerDto getAuthorizerByAppId(String authorizerAppId) throws BizException;


    /**
     * @param dto
     * @return
     * @throws BizException
     */
    boolean saveAuthorizer(WxAuthorizerDto dto) throws BizException;



    boolean unauthorized(String authorizerAppId) throws BizException;


    /**
     *
     * @param dto
     * @return true
     * @throws BizException
     */
    boolean updateAuthorizer(WxAuthorizerDto dto) throws BizException;


    /**
     *
     * @param authorizerAppId
     * @return true
     * @throws BizException
     */
    boolean deleteAuthorizerAccessTokenByAppId(String authorizerAppId) throws BizException;


    /**
     *
     * @param dto
     * @return true
     * @throws BizException
     */
    boolean saveAuthorizerAccessToken(WxAuthorizerAccessTokenDto dto) throws BizException;


    /**
     * @return
     * @throws BizException
     */
    boolean saveWeChatApp(WeAppDto dto) throws BizException;


    /**
     * 查询公众号是否授权
     *
     * @param appKey
     * @return
     * @throws BizException
     */
    WeAppDto getByAppKey(String appKey) throws BizException;


    /**
     * 查询公众号是否授权
     *
     * @param wechatAppId
     * @return
     * @throws BizException
     */
    WeAppDto getByWechatAppId(String wechatAppId) throws BizException;


}
