package cn.com.duiba.wechat.server.api.param;

/**
 * @program: wechat-server
 * @description: 微信小程序推送
 * @author: fenghuohuo
 * @create: 2021-09-05 16:13
 **/
public class WxMiniAppSendMsgParam {
    private String appId;

    /**
     * 接收者（用户）的 openid
     */
    private String touser;
    /**
     * 所需下发的订阅模板id
     */
    private String templateId;
    /**
     * 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。
     */
    private String page;

    /**
     * 跳转小程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版
     */
    private String miniprogramState;

    /**
     * 进入小程序查看”的语言类型，支持zh_CN(简体中文)、en_US(英文)、zh_HK(繁体中文)、zh_TW(繁体中文)，默认为zh_CN
     */
    private String lang;
    /**
     * 模板内容，格式形如 { "key1": { "value": any }, "key2": { "value": any } }
     */
    private String data;

    public String getAppId() {
        return appId;
    }

    public WxMiniAppSendMsgParam setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getTouser() {
        return touser;
    }

    public WxMiniAppSendMsgParam setTouser(String touser) {
        this.touser = touser;
        return this;
    }

    public String getTemplateId() {
        return templateId;
    }

    public WxMiniAppSendMsgParam setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public String getPage() {
        return page;
    }

    public WxMiniAppSendMsgParam setPage(String page) {
        this.page = page;
        return this;
    }

    public String getMiniprogramState() {
        return miniprogramState;
    }

    public WxMiniAppSendMsgParam setMiniprogramState(String miniprogramState) {
        this.miniprogramState = miniprogramState;
        return this;
    }

    public String getLang() {
        return lang;
    }

    public WxMiniAppSendMsgParam setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public String getData() {
        return data;
    }

    public WxMiniAppSendMsgParam setData(String data) {
        this.data = data;
        return this;
    }
}
