package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.SessionBeanDto;

/**
 * @author haojiahong
 * @date 2022-07-22
 */
@AdvancedFeignClient
public interface RemoteWeChatSelfMiniAppService {

    /**
     * 获取openid
     *
     * @param appid
     * @param secret
     * @param code
     * @return
     */
    SessionBeanDto jscode2session(String appid, String secret, String code);

    /**
     * 获取openLink
     *
     * @param appid
     * @param secret
     * @param path
     * @param query
     * @param envVersion
     * @param expireType
     * @param expireTime
     * @param expireInterval
     * @return
     * @throws BizException
     */
    String generateScheme(String appid, String secret, String path, String query, String envVersion,
                          String expireType, String expireTime, String expireInterval) throws BizException;


}
