package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WxQrSceneSubscribeDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2020/5/6 17:18
 */
@AdvancedFeignClient
public interface RemoteWxQrSceneSubscribeSerivice {

    /**
     * 根据 openId 获取用户的信息，主要用于查询用户是通过哪一个带参二维码进入的
     * 如果 openId 为 null, 结果返回 null
     *
     * @param openId not null 用户openId
     * @return 用户信息
     */
    WxQrSceneSubscribeDto getByOpenId(String openId);

    /**
     * 获取关注列表
     *
     * 该接口只会返回调用时刻的关注列表，用户取关后，会同步更新关注状态，该接口返回的数据会随着更新
     *
     * 例如：5 分钟前调用该接口，A 用户关注了，会在结果中返回；5 分钟后，A 用户取关，那么再次调用该接口， A用户不会在结果中

     * 如果参数中有一个为 null, 返回{@link java.util.Collections#emptyList()}
     *
     * @param appId      not null 应用ID
     * @param relationId not null 活动ID
     * @param sceneId    not null 带参二维码参数
     * @return 关注列表
     */
    List<WxQrSceneSubscribeDto> getSubscribeList(Long appId, Long relationId, Long sceneId);

    /**
     * 获取所有扫描该场景值二维码的用户列表，结果中返回
     * A：firstScanStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#UNSUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#SUBSCRIBE}
     * <p>
     * B：firstScanStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#UNSUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#UNSUBSCRIBE}
     * <p>
     * C：firstScanStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#SUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#SUBSCRIBE}
     * <p>
     * D：firstScanStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#SUBSCRIBE}，
     * subscribeStatus is {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum#UNSUBSCRIBE}
     * 四个用户数据
     * <p>
     * A 和 B 表示是扫了这个码进行关注的，也就是这个{@code sceneId }吸引了两个用户关注，但是 B 用户后面又取消关注了。
     * <p>
     * C 和 D 表示之前都关注了公众号，但是是通过扫描带{@code sceneId }的二维码进入的，后来 D 用户取消关注了。
     * <p>
     * 如果参数中有一个为 null, 返回{@link java.util.Collections#emptyList()}
     *
     * @param appId      not null 应用ID
     * @param relationId not null 活动ID
     * @param sceneId    not null 带参二维码参数
     * @return 所有用户列表
     */
    List<WxQrSceneSubscribeDto> getAllScanList(Long appId, Long relationId, Long sceneId);

    /**
     * 获取关注数量
     * 如果 appId 为 null, 返回 0
     *
     * @param appId      not null 应用ID
     * @param relationId nullable 活动ID
     * @param sceneId    nullable 带参二维码参数
     * @return 关注列表
     */
    Long getSubscribeCount(Long appId, Long relationId, Long sceneId);
}
