package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WxSubscribeEventDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2020/7/2 17:09
 */
@AdvancedFeignClient
public interface RemoteWxSubscribeEventService {

    /**
     * 获取用户所有的关注事件
     * @param consumerId 用户ID
     * @return 关注事件列表
     */
    List<WxSubscribeEventDto> getUserSubscribeEvents(Long consumerId);

    /**
     * 获取用户的关注事件
     * @param consumerId
     * @param subscribeStatus 关注状态 {@link cn.com.duiba.wechat.server.api.enums.SubscribeEnum}

     * @return
     */
    WxSubscribeEventDto getUserSubscribeEvent(Long consumerId, Integer subscribeStatus);
}
