package cn.com.duiba.wechat.server.api.util;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author chengsiyi
 */
public class MD5 {

    private static String[] hexDigits = { "0", "1", "2", "3", "4", "5", "6","7", "8", "9", "a", "b", "c", "d", "e", "f" };

    private static final Logger logger = LoggerFactory.getLogger(MD5.class);

    private static String md5(String sourceStr, int type) {
        String result = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sourceStr.getBytes());
            byte[] b = md.digest();
            int i;
            StringBuilder buf = new StringBuilder("");
            for (byte aB : b) {
                i = aB;
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            if(type == 32) {
                result = buf.toString();
            }else if(type == 16){
                result = buf.toString().substring(8, 24);
            }
        } catch (NoSuchAlgorithmException e) {
            logger.error("md5加密发生异常!没有找到相关算法", e);
        }
        return result;
    }

    public static String md5EncryptTo32(String sourceStr){
        return md5(sourceStr,32).toUpperCase();
    }

    public static String md5EncryptTo16(String sourceStr){
        return md5(sourceStr,16).toUpperCase();
    }

    public static String md5New(String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] b = data.getBytes("UTF8");
        md5.update(b, 0, b.length);
        return byteArrayToHexString(md5.digest());
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; i++) {
            sb.append(byteToHexString(b[i]));
        }

        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}
