/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wechat.server.api.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 7000;
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final Logger logger;

    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        logger.info("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8bf7\u6c42url={},\u8bf7\u6c42\u53c2\u6570\u4e3a{}.", (Object)apiUrl, (Object)JSONObject.toJSONString(params));
        HttpPost httpPost = new HttpPost(apiUrl);
        httpPost.setHeader("model", "customer");
        httpPost.setHeader("store_code", "310117");
        httpPost.setHeader("method", "get");
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setConfig(requestConfig);
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
            pairList.add(pair);
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARACTER_ENCODE)));
        return HttpUtil.sendPost(httpPost);
    }

    public static String doPostSSL(String url, String json) {
        logger.info("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8bf7\u6c42url={},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)url, (Object)json);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(json, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return HttpUtil.sendPost(httpPost);
    }

    public static String doPostSSLWithHead(HttpPost httpPost, String json) {
        logger.info("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8bf7\u6c42url={},\u8bf7\u6c42\u53c2\u6570\u4e3a{}.", (Object)httpPost.getURI(), (Object)json);
        StringEntity stringEntity = new StringEntity(json, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return HttpUtil.sendPost(httpPost);
    }

    public static String doPostSSL(String apiUrl, HttpEntity httpEntity) {
        logger.info("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8bf7\u6c42url={},\u8bf7\u6c42\u53c2\u6570\u4e3a{}.", (Object)apiUrl);
        HttpPost httpPost = new HttpPost(apiUrl);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("content-Type", "multipart/form-data");
        httpPost.setEntity(httpEntity);
        return HttpUtil.sendPost(httpPost);
    }

    public static String sendPost(HttpPost post) {
        String resp = "";
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            HttpEntity entity = response.getEntity();
            resp = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
        }
        catch (IOException e) {
            logger.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        logger.info("post\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)resp);
        return resp;
    }

    public static String doPostSSLByStream(String url, String json) {
        logger.info("\u53d1\u9001post\u8bf7\u6c42\uff0c\u8bf7\u6c42url={},\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)url, (Object)json);
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(json, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return HttpUtil.sendPostByStream(httpPost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostByStream(HttpPost post) {
        String resp = "";
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        try (CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);){
            HttpEntity entity = result.getEntity();
            InputStream inputStream = entity.getContent();
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = inputStream.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] data = swapStream.toByteArray();
            String string = new String(Base64.getEncoder().encode(data));
            return string;
        }
        catch (IOException e) {
            logger.warn("\u53d1\u9001post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            logger.info("post\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)resp);
            return resp;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGetSSLWithHead(HttpGet httpGet) {
        logger.info("\u53d1\u9001get\u8bf7\u6c42\uff0c\u8bf7\u6c42url={}", (Object)httpGet.getURI());
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        httpGet.setConfig(requestConfig);
        String httpStr = "";
        try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);){
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = resp.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
        }
        catch (IOException e) {
            logger.warn("\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        logger.info("get\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)httpStr);
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendGet(String url) {
        logger.info("\u53d1\u9001get\u8bf7\u6c42\uff0c\u8bf7\u6c42url={}.", (Object)url);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        String httpStr = "";
        try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet);){
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = resp.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
        }
        catch (IOException e) {
            logger.warn("\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        logger.info("get\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)httpStr);
        return httpStr;
    }

    public static String sendGet(String firstUrl, String redirectUrl) {
        HttpClientContext context = HttpClientContext.create();
        HttpUtil.sendGet(firstUrl, context);
        return HttpUtil.sendGet(redirectUrl, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String sendGet(String url, HttpClientContext context) {
        logger.info("\u53d1\u9001get\u8bf7\u6c42\uff0c\u8bf7\u6c42url={}.", (Object)url);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        String httpStr = "";
        try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);){
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = resp.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARACTER_ENCODE);
        }
        catch (IOException e) {
            logger.warn("\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        logger.info("get\u8bf7\u6c42\u7ed3\u679c\u4e3a:{}.", (Object)httpStr);
        return httpStr;
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, (arg0, arg1) -> true);
        }
        catch (GeneralSecurityException e) {
            logger.error("\u521b\u5efassl\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return sslsf;
    }

    static {
        logger = LoggerFactory.getLogger(HttpUtil.class);
        connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        connMgr.setValidateAfterInactivity(10000);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(7000);
        configBuilder.setSocketTimeout(7000);
        configBuilder.setConnectionRequestTimeout(7000);
        requestConfig = configBuilder.build();
    }
}

