package cn.com.duiba.wolf.threadpool;

import com.alibaba.ttl.TtlRunnable;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.*;

/**
 * 一般性的线程池，给业务做异步使用，线程池大小2~10
 * Created by wuche on 2017/1/23.
 */
public final class DBBizThreadPoolManager {

    //内部类，确保线程池只有需要的时候才会被创建
    private static class Holder{
        protected static DBBizThreadPoolManager sThreadPoolManager = new DBBizThreadPoolManager();
    }

    // 线程池维护线程的最少数量
    private static final int SIZE_CORE_POOL = 6;

    // 线程池维护线程的最大数量
    private static final int SIZE_MAX_POOL = 10;

    // 线程池维护线程所允许的空闲时间
    private static final int TIME_KEEP_ALIVE = 5000;

    // 线程池所使用的缓冲队列大小
    private static final int SIZE_WORK_QUEUE = 500;

    /*
     * 线程池单例创建方法
     */
    public static DBBizThreadPoolManager getInstance() {
        return Holder.sThreadPoolManager;
    }

    /*
     * 线程池
     */
    private final ThreadPoolExecutor mThreadPool = new ThreadPoolExecutor(SIZE_CORE_POOL, SIZE_MAX_POOL,
            TIME_KEEP_ALIVE, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(SIZE_WORK_QUEUE),new NamedThreadFactory("DBBizThreadPoolManager"));

    /*
     * 将构造方法访问修饰符设为私有，禁止任意实例化。
     */
    private DBBizThreadPoolManager() {
    }

    public void perpare() {
        if (mThreadPool.isShutdown() && !mThreadPool.prestartCoreThread()) {
            @SuppressWarnings("unused")
            int startThread = mThreadPool.prestartAllCoreThreads();
        }
    }

    /*
     * 向线程池中添加任务方法
     */
    public void submit(Runnable task) {
        if (task != null) {
            mThreadPool.execute(TtlRunnable.get(task));
        }
    }

    public void shutdown() {
        mThreadPool.shutdown();
    }
}
