/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf.timeprofile;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestTool {
    private static ThreadLocal<HttpServletRequest> request = new ThreadLocal();

    public static HttpServletRequest getHttpServletRequest() {
        return request.get();
    }

    public static void setRequestInThreadLocal(HttpServletRequest req) {
        request.set(req);
    }

    public static String getRequestIpInThreadLocal() {
        HttpServletRequest req = request.get();
        if (req != null) {
            return RequestTool.getIpAddr(req);
        }
        return null;
    }

    public static String getRequestUAInThreadLocal() {
        HttpServletRequest req = request.get();
        if (req != null) {
            return req.getHeader("User-Agent");
        }
        return null;
    }

    public static String getNewRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return url;
        }
        return url + "?" + queryString;
    }

    public static String getRequestUrl(HttpServletRequest request) {
        String path;
        String queryString = request.getQueryString();
        queryString = queryString == null ? "" : "?" + queryString;
        if ("post".equalsIgnoreCase(request.getMethod())) {
            queryString = "?" + queryString;
            Map map = request.getParameterMap();
            for (String key : map.keySet()) {
                if (((String[])map.get(key)).length <= 0) continue;
                queryString = queryString + key + "=" + ((String[])map.get(key))[0] + "&";
            }
        }
        if ((path = (String)request.getAttribute("javax.servlet.forward.request_uri")) != null) {
            return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + queryString;
        }
        return request.getRequestURL().toString();
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static String getOS(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            return "Unkonwn";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "iPad";
            }
            if (ua.contains("iphone")) {
                return "iPhone";
            }
            if (ua.contains("android")) {
                return "Android";
            }
            if (ua.contains("linux")) {
                return "Linux";
            }
            if (ua.contains("windows")) {
                return "Windows";
            }
            if (ua.contains("macintosh")) {
                return "Mac";
            }
        }
        return "Unknown";
    }

    public static String getOSNew(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            return "6";
        }
        if (ua != null) {
            if ((ua = ua.toLowerCase()).contains("ipad")) {
                return "4";
            }
            if (ua.contains("iphone")) {
                return "1";
            }
            if (ua.contains("android")) {
                return "0";
            }
            if (ua.contains("linux")) {
                return "5";
            }
            if (ua.contains("windows")) {
                return "2";
            }
            if (ua.contains("macintosh")) {
                return "3";
            }
            if (ua.contains("ios")) {
                return "6";
            }
        }
        return "6";
    }

    public static String getOSNew(String ua) {
        if (ua == null) {
            return "6";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "4";
            }
            if (ua.contains("iphone")) {
                return "1";
            }
            if (ua.contains("android")) {
                return "0";
            }
            if (ua.contains("linux")) {
                return "5";
            }
            if (ua.contains("windows")) {
                return "2";
            }
            if (ua.contains("macintosh")) {
                return "3";
            }
            if (ua.contains("ios")) {
                return "6";
            }
        }
        return "6";
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String ip = RequestTool.getIpAddr(request);
        return ip.startsWith("127.0.0.1") || ip.startsWith("0:0:0:0");
    }

    public static boolean isHttpsRequest(HttpServletRequest request) {
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String value;
                Cookie c = cookies[i];
                if (!name.equals(c.getName()) || (value = c.getValue()) == null || value.length() <= 0) continue;
                return value;
            }
        }
        return null;
    }

    public static String getServerPath(HttpServletRequest request) {
        String port = String.valueOf(request.getServerPort());
        port = "80".equals(port) ? "" : ":" + port;
        String serverUrl = request.getScheme() + "://" + request.getServerName() + port;
        return serverUrl;
    }
}

