package cn.com.duiba.wolf.spring.velocity;

import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by wenqi.huang on 2016/12/22.
 */
public class VelocityClasspathResourceLoader extends ClasspathResourceLoader{

    private List<String> paths = new ArrayList<>();

    @Override
    public void init(ExtendedProperties configuration) {
        super.init(configuration);
        for(Object pathObj : configuration.getVector("path")){
            String path = (String)pathObj;
            if(path == null){
                continue;
            }
            if(path.endsWith("/")){
                path = path.substring(0, path.length() - 1);
            }
            paths.add(path);
        }
    }

    @Override
    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(name)){
            throw new ResourceNotFoundException ("No template name provided");
        }
        if(!name.startsWith("/")){
            name = "/" + name;
        }

        InputStream is = null;
        for(String path : paths) {
            try {
                is = super.getResourceStream(path + name);
            }catch(ResourceNotFoundException e){
                // do nothing
                log.warn("try to find vm : " + path + name + ",but not found.", e);
            }
        }
        if(is == null){
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name;

            throw new ResourceNotFoundException( msg );
        }

        return is;
    }

}
