package cn.com.duiba.wolf.threadpool;

import com.alibaba.ttl.threadpool.TtlExecutors;

import java.util.concurrent.*;

/**
 * 单线程的线程池，给需要单线程的异步任务使用
 * Created by wuche on 2017/1/24.
 */
public final class DBSingleThreadPoolManager {

    //内部类，确保线程池只有需要的时候才会被创建
    private static class Holder{
        protected static DBSingleThreadPoolManager sThreadPoolManager = new DBSingleThreadPoolManager();
    }

    /*
     * 线程池单例创建方法
     */
    public static DBSingleThreadPoolManager getInstance() {
        return Holder.sThreadPoolManager;
    }

    /*
     * 线程池
     */
    private final ExecutorService mThreadPool = TtlExecutors.getTtlExecutorService(Executors.newSingleThreadExecutor());

    /*
     * 将构造方法访问修饰符设为私有，禁止任意实例化。
     */
    private DBSingleThreadPoolManager() {
    }

    /*
     * 向线程池中添加任务方法
     */
    public void submit(Runnable task) {
        if (task != null) {
            mThreadPool.execute(task);
        }
    }
}
