package cn.com.duiba.wolf.cache;

import org.springframework.data.redis.core.RedisTemplate;

import java.beans.PropertyEditorSupport;

/**
 * 这个类负责把RedisTemplate 转换成 RedisCacheClient。
 *
 * spring会自动找到这个类（*Editor）,spring的Editor机制
 *
 * Created by wenqi.huang on 2017/1/14.
 */
public class RedisCacheClientEditor extends PropertyEditorSupport {

    @Override
    public void setValue(Object value) {
        if (value instanceof RedisTemplate) {
            RedisCacheClient redisCacheClient = new RedisCacheClient((RedisTemplate)value);
            super.setValue(redisCacheClient);
        } else {
            throw new java.lang.IllegalArgumentException("Editor supports only conversion of type " + RedisTemplate.class);
        }
    }
}
