package cn.com.duiba.wolf.cache;

import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.exception.MemcachedException;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * 缓存客户端接口
 */
public interface CacheClient extends AdvancedCacheClient {

    /**
     * 添加，如果key已经存在则拒绝并返回false
     * @param key
     * @return
     */
	public boolean add(String key, int exp, Object value) throws Exception;
	
    public long getLong(String key);

    /**
     * 清空所有缓存
     */
    void flushAll();

    // /**
    // * 是否包含key
    // *
    // * @param key
    // * @return
    // */
    // boolean containsKey(String key);

    public long incr(String key, long by);

    public long incr(String key, long by, long exp, TimeUnit timeUnit);

    public long incr(String key, long delta, long initValue, long expiry, TimeUnit unit);

    public long decr(String key, long by);

    public long decr(String key, long by, long exp, TimeUnit timeUnit);

    public long decr(String key, long delta, long initValue, long expiry, TimeUnit unit);

    /**
     * 获得当前值和cas值
     * @param key
     * @return
     */
    public <T> GetsResponse<T> gets(String key);

    /**
     * 获得多个当前值和cas值
     * @param keys
     * @return
     */
    public <T> Map<String, GetsResponse<T>> gets(Collection<String> keys);

    /**
     * CAS
     * @param key
     * @param casOperation
     * @param <T>
     * @return
     */
    public <T> boolean cas(String key, CASOperation<T> casOperation);

    /**
     * CAS
     * @param key
     * @param expSeconds
     * @param casOperation
     * @param <T>
     * @return
     */
    public <T> boolean cas(String key, int expSeconds, CASOperation<T> casOperation);

    /**
     * CAS
     * @param key
     * @param exp
     * @param timeUnit
     * @param value
     * @param currentCas cas值
     * @param <T>
     * @return
     */
    public boolean cas(String key, int exp, TimeUnit timeUnit, Object value, long currentCas);

    /**
     * CAS操作
     * @param key key必须已经在缓存中存在,否则会返回false
     * @param expectedValue 期望的值
     * @param newValue 要替换的值
     * @param expSeconds 缓存超时时间
     * @return
     */
    public boolean casByValue(String key, Object expectedValue, Object newValue, int expSeconds);

}
