package cn.com.duiba.wolf.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javassist.ClassPool;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.context.ApplicationContext;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.google.common.base.Preconditions;

/**
 * <pre>
 * Created by xuezhaoming-inter12 on 14-10-10.上午11:53
 * </pre>
 */
public class InitOperation {

    private static final Logger     LOG               = LoggerFactory.getLogger(InitOperation.class);

    private static volatile boolean initialized       = false;

    private static final String     DEFAULT_PATH      = "/META-INF/wolf/wolf.properties";

    public static final int         DEFAULT_THRESHOLD = 500;

    public static synchronized void init() {
        if (initialized) {
            return;
        }

        LOG.info(" ----------- start class file  duplicate check   -----------");

        final String configPath = System.getProperty("wolf.properties", DEFAULT_PATH);

        VersionCheck.checkDuplicate(Logger.class);// sl4j
        VersionCheck.checkDuplicate(Preconditions.class);// guava
        VersionCheck.checkDuplicate(ApplicationConfig.class);// dubbo
        VersionCheck.checkDuplicate(ApplicationContext.class);// spring-context
        VersionCheck.checkDuplicate(BeanInfoFactory.class);// spring-bean
        VersionCheck.checkDuplicate("org.junit.Assume.class");// junit
        VersionCheck.checkDuplicate(ClassPool.class);// javassist
        VersionCheck.checkDuplicate(DEFAULT_PATH);// properties
        VersionCheck.checkDuplicate(configPath);// properties

        LOG.info(" ----------- end class file  duplicate check   -----------");

        LOG.info(" ----------- start init config  -----------");
        int threshold = DEFAULT_THRESHOLD;
        String dubboSystemName = "--";
        InputStream propertiesInputStream = InitOperation.class.getResourceAsStream(configPath);

        if(propertiesInputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(propertiesInputStream);
                String thresholdStr = properties.getProperty("timeprofile.threshold");
                String dubboSystemNameTemp = properties.getProperty("dubbo.system.name");
                if(!StringUtils.isBlank(dubboSystemNameTemp)){
                    dubboSystemName = dubboSystemNameTemp;
                }

                if (NumberUtils.isNumber(thresholdStr)) {
                    threshold = Integer.valueOf(thresholdStr);
                }

            } catch (Exception e) {

                LOG.error(" ----------- init time profile  error !  -----------" + EnvInfo.getEnvInfo(), e);

            } finally {
                if (propertiesInputStream != null) {
                    try {
                        propertiesInputStream.close();
                    } catch (IOException e) {
                        LOG.warn("close InputStream error . from : /META-INF/wolf/wolf.properties  " + EnvInfo.getEnvInfo());
                    }
                }


                LOG.info("threshold info {}", threshold);
            }
        }
        DBTimeProfile.setThreshold(threshold);
        RuntimeExceptionFilter.registerSystemName(dubboSystemName);

        LOG.info(" ----------- end of  init   config  -----------");
        initialized = true;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        try {
            properties.load(InitOperation.class.getResourceAsStream("/META-INF/wolf/wolf.properties"));
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(properties.isEmpty());
    }
}
