package cn.com.duiba.wolf.threadpool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.BlockingQueue;

/**
 * runnable的包装类，可以监控Runnable从提交到线程池到开始执行花了多久，如果过久则打印warn日志
 * Created by wenqi.huang on 2017/2/5.
 */
public class MonitorRunnable implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRunnable.class);

    //一个线程如果从提交线程池到开始执行的时间超过此阈值，则打印warn日志
    static final int MAX_WAIT_TIME_MILLIS = 1000;

    private Runnable runnable;

    /**
     * 线程池中的queue，当超时的时候可以打印出大小
     */
    private BlockingQueue<Runnable> queue;

    //这个时间用于记录什么时候提交到线程池
    private final long submitTimeMillis;

    public MonitorRunnable(Runnable runnable){
        this.runnable = runnable;
        submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorRunnable(Runnable runnable, BlockingQueue<Runnable> queue){
        this(runnable);
        this.queue = queue;
    }

    @Override
    public void run() {
        long waitTimeMillis = System.currentTimeMillis() - submitTimeMillis;
        if(waitTimeMillis >= MAX_WAIT_TIME_MILLIS){
            if(queue == null) {
                logger.error("ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis});
            }else{
                logger.error("ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{Thread.currentThread().getName(), waitTimeMillis, queue.size()});
            }
        }

        runnable.run();
    }
}
