package cn.com.duiba.wolf.utils;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;

/**
 * 提供加解密等方法
 * @author wenqi.huang on 16/4/11.
 */
public final class SecurityUtils {

    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    /**
     * 用SHA(即SHA1)算法编码成字节数组
     * 
     * @param src 待编码数据
     * @return 编码后字节数组
     */
    public static byte[] encode2BytesBySHA(String src) {
        return DigestUtils.sha1(src);
    }

    /**
     * 用SHA算法编码成字符串
     * 
     * @param src 待加密文本
     * @return 加密后文本
     */
    public static String encode2StringBySHA(String src) {
        return DigestUtils.sha1Hex(src.getBytes(DEFAULT_CHARSET));
    }

    /**
     * 针对传入数据进行MD5 hash
     * 
     * @param src 待编码数据
     * @return 加密后字符串
     */
    public static String encode2StringByMd5(String src) {
        return DigestUtils.md5Hex(src.getBytes(DEFAULT_CHARSET));
    }

    /**
     * 针对传入数据进行MD5 hash
     *
     * @param src 待编码数据
     * @return 加密后字符串
     */
    public static String encode2StringByMd5(byte[] src) {
        return DigestUtils.md5Hex(src);
    }

    /**
     * 把字节数组编码成base64字符串
     * @param bytes
     * @return
     */
    public static String encode2StringByBase64(byte[] bytes) {
        return Base64.encodeBase64String(bytes);
    }

    /**
     * 把base64字节数组进行解码
     * @param bytes
     * @return
     */
    public static byte[] decodeBase64(byte[] bytes) {
        return Base64.decodeBase64(bytes);
    }

    /**
     * 把base64字符串进行解码
     * @param src
     * @return
     */
    public static byte[] decodeBase64(String src) {
        return Base64.decodeBase64(src);
    }

    private static byte[] encodeOrDecodeByAes(byte[] content, String key, boolean isEncode){
        try {
            SecretKeySpec key1 = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");// 创建密码器
            cipher.init(isEncode ? Cipher.ENCRYPT_MODE : Cipher.DECRYPT_MODE, key1);// 初始化
            return cipher.doFinal(content);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /**
     * 使用AES算法加密
     * @param content
     * @param key 16/24/32位字符串(16位字符串即128bit)
     * @return 加密结果，不能直接转成字符串，如需要，请使用base64编码转成字符串
     */
    public static byte[] encodeByAes(String content, String key){
        return encodeByAes(content.getBytes(DEFAULT_CHARSET), key);
    }

    /**
     * 使用AES算法加密
     * @param content
     * @param key 16/24/32位字符串
     * @return 加密结果，不能直接转成字符串，如需要，请使用base64编码转成字符串
     */
    public static byte[] encodeByAes(byte[] content, String key){
        return encodeOrDecodeByAes(content, key, true);
    }

    /**
     * 使用AES算法解密
     * @param content
     * @param key 16/24/32位字符串
     * @return 解密结果，如果加密前是字符串，则可以直接转换成字符串
     */
    public static byte[] decodeByAes(String content, String key){
        return encodeOrDecodeByAes(content.getBytes(DEFAULT_CHARSET), key, false);
    }

    /**
     * 使用AES算法解密
     * @param content
     * @param key 16/24/32位字符串
     * @return 解密结果，如果加密前是字符串，则可以直接转换成字符串
     */
    public static byte[] decodeByAes(byte[] content, String key){
        return encodeOrDecodeByAes(content, key,false);
    }

}
