/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.cache;

import cn.com.duiba.boot.ext.autoconfigure.redis.Hessian2SerializationRedisSerializer;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.entity.Null;
import cn.com.duiba.wolf.log.DegradeLogger;
import cn.com.duiba.wolf.utils.CatUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCacheClient
implements AdvancedCacheClient {
    private static final Logger logger = DegradeLogger.wrap(LoggerFactory.getLogger(RedisCacheClient.class));
    private final RedisTemplate redisTemplate;
    private RedisSerializer<String> keyRedisSerializer = new StringRedisSerializer();
    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    public RedisCacheClient(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public <T> T get(String key) {
        T t = this.getInner(key);
        if (t != null && t instanceof Null) {
            return null;
        }
        return t;
    }

    @Override
    public boolean set(String key, Object value, final int timeout, final TimeUnit unit) {
        if (value == null) {
            return false;
        }
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    this.potentiallyUsePsetEx(connection);
                    return null;
                }

                public void potentiallyUsePsetEx(RedisConnection connection) {
                    if (!TimeUnit.MILLISECONDS.equals((Object)unit) || !this.failsafeInvokePsetEx(connection)) {
                        connection.setEx(rawKey, TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit), rawValue);
                    }
                }

                private boolean failsafeInvokePsetEx(RedisConnection connection) {
                    boolean failed = false;
                    try {
                        connection.pSetEx(rawKey, (long)timeout, rawValue);
                    }
                    catch (UnsupportedOperationException e) {
                        failed = true;
                    }
                    return !failed;
                }
            }, true);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            CatUtils.logError(e);
            return false;
        }
        return true;
    }

    private <T> T getInner(String key) {
        final byte[] rawKey = this.rawKey(key);
        try {
            return (T)this.redisTemplate.execute(new RedisCallback<T>(){

                public T doInRedis(RedisConnection connection) throws DataAccessException {
                    byte[] valueBytes = connection.get(rawKey);
                    return RedisCacheClient.this.valueRedisSerializer.deserialize(valueBytes);
                }
            }, true);
        }
        catch (Exception e) {
            logger.error("get key error:" + key, (Throwable)e);
            CatUtils.logError(e);
            return null;
        }
    }

    @Override
    public <T> T getWithCacheLoader(String key, int timeout, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T value = this.getInner(key);
        if (value == null) {
            value = cacheLoader.load();
            if (isCacheNull) {
                this.setWithNull(key, value, timeout, timeUnit);
            } else if (value != null) {
                this.set(key, value, timeout, timeUnit);
            }
        }
        if (value instanceof Null) {
            value = null;
        }
        return value;
    }

    protected void setWithNull(String key, Object value, int timeout, TimeUnit unit) {
        if (value == null) {
            value = Null.NULL;
        }
        this.set(key, value, timeout, unit);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return this.getWithCacheLoader(key, exp, timeUnit, false, cacheLoader);
    }

    @Override
    public boolean remove(String key) {
        final byte[] rawKey = this.rawKey(key);
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.del((byte[][])new byte[][]{rawKey});
                    return null;
                }
            }, true);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            CatUtils.logError(e);
            return false;
        }
        return true;
    }

    private byte[] rawKey(String key) {
        return this.keyRedisSerializer.serialize((Object)key);
    }

    private byte[] rawValue(Object value) {
        return this.valueRedisSerializer.serialize(value);
    }
}

