/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class HtmlUtils {
    private static PolicyFactory policyBuilder = new HtmlPolicyBuilder().allowAttributes(new String[]{"src", "title"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"class", "id", "style"}).onElements(new String[]{"span"}).allowStandardUrlProtocols().allowElements(new String[]{"a", "label", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "font", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "col", "fieldset", "legend", "samp", "cite", "pre", "code", "big", "small"}).toFactory();

    public static String cleanXss(String htmlString) {
        if (StringUtils.isBlank((String)htmlString)) {
            return htmlString;
        }
        String htmlString1 = HtmlUtils.preprocess(htmlString);
        return policyBuilder.sanitize(htmlString1);
    }

    @Deprecated
    private static String preprocess(String htmlString) {
        String parsedHtml = org.apache.commons.lang.StringUtils.replace((String)htmlString, (String)"\uff1f", (String)"?");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff01", (String)"!");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff0c", (String)",");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff1b", (String)";");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff08", (String)"(");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff09", (String)")");
        parsedHtml = org.apache.commons.lang.StringUtils.replace((String)parsedHtml, (String)"\uff1a", (String)":");
        return parsedHtml;
    }

    public static String cleanXssOfJsonString(String jsonString) {
        if (StringUtils.isBlank((String)jsonString)) {
            return jsonString;
        }
        if ((jsonString = HtmlUtils.preprocess(jsonString)).startsWith("[")) {
            JSONArray jsonArray = HtmlUtils.cleanXssOfJsonArray(JSONArray.fromObject((Object)jsonString));
            return jsonArray.toString();
        }
        if (jsonString.startsWith("{")) {
            JSONObject jsonObject = HtmlUtils.cleanXssOfJsonObject(JSONObject.fromObject((Object)jsonString));
            return jsonObject.toString();
        }
        return jsonString;
    }

    private static JSONArray cleanXssOfJsonArray(JSONArray jsonArray) {
        if (jsonArray.isEmpty()) {
            return jsonArray;
        }
        JSONArray retJsonArray = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object object = jsonArray.get(i);
            if (object instanceof JSONArray) {
                retJsonArray.add((Object)HtmlUtils.cleanXssOfJsonArray((JSONArray)object));
                continue;
            }
            if (object instanceof JSONObject) {
                retJsonArray.add((Object)HtmlUtils.cleanXssOfJsonObject((JSONObject)object));
                continue;
            }
            if (object instanceof String) {
                retJsonArray.add((Object)HtmlUtils.cleanXss((String)object));
                continue;
            }
            retJsonArray.add(object);
        }
        return retJsonArray;
    }

    private static JSONObject cleanXssOfJsonObject(JSONObject jsonObject) {
        if (jsonObject.isEmpty()) {
            return jsonObject;
        }
        JSONObject retJsonObject = new JSONObject();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof JSONArray) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXssOfJsonArray((JSONArray)object));
                continue;
            }
            if (object instanceof JSONObject) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXssOfJsonObject((JSONObject)object));
                continue;
            }
            if (object instanceof String) {
                retJsonObject.put((Object)key, (Object)HtmlUtils.cleanXss((String)object));
                continue;
            }
            retJsonObject.put((Object)key, object);
        }
        return retJsonObject;
    }
}

