package cn.com.duiba.wolf.perf;

import com.google.common.base.Preconditions;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by xuezhaoming on 16/5/31.<br/>
 * 性能测试门面类
 */
public class Performances {

    // 启用并发数
    private int                 count;

    // 循环次数
    private int                 loop;

    // 可运行接口
    private PerfRunable         perfRunable;

    // 数据收集器
    private final PerfCollector perfCollector = new PerfCollector();

    public static Performances newBuilder() {
        return new Performances();
    }

    public Performances count(int count) {
        this.count = count;
        return this;
    }

    public Performances perfRunable(PerfRunable perfRunable) {
        this.perfRunable = perfRunable;
        return this;
    }

    public Performances loop(int loop) {
        this.loop = loop;
        return this;
    }

    public PerfResult start() {

        Preconditions.checkArgument(loop > 0, "loop must bigger than 0");
        Preconditions.checkArgument(count > 0, "count must bigger than 0");

        ExecutorService executorService = Executors.newFixedThreadPool(count);

        final CountDownLatch countDown = new CountDownLatch(loop);

        perfCollector.setStartTime(System.currentTimeMillis());
        for (int i = 0; i < loop; i++) {

            executorService.submit(new Runnable() {

                @Override
                public void run() {

                    for (int j = 0; j < count; j++) {

                        try {

                            long startTime = System.currentTimeMillis();
                            perfRunable.run();

                            long endTime = System.currentTimeMillis();

                            perfCollector.addValue(endTime - startTime);

                            perfCollector.addSuccess();
                        } catch (Exception e) {

                            perfCollector.addFail();
                        }

                    }

                    countDown.countDown();

                }
            });

        }

        try {
            countDown.await();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        perfCollector.setEndTime(System.currentTimeMillis());

        return perfCollector.compute();
    }

}
