package cn.com.duiba.wolf.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/5/26. <br/>
 * 兑吧统一的logger服务
 */
public final class DBLogger {

    // 日志记录器
    private Logger  logger;

    // 日志记录类前缀
    private Class   aClass;

    private boolean isFinish = false;

    /**
     * 建造者模式创建对象
     * 
     * @return
     */
    public static DBLogger builder() {
        return new DBLogger();
    }

    public DBLogger aClass(Class aClass) {
        this.aClass = aClass;
        return this;
    }

    public DBLogger build() {

        if (aClass == null) {
            aClass = DBLogger.class;
        }
        logger = LoggerFactory.getLogger(aClass);
        isFinish = true;
        return this;
    }

    /**
     * 记录错误编码
     * 
     * @param code 编码
     * @param msg 内容
     * @param e 异常
     */
    public void error(String code, String msg, Exception e) {

        Preconditions.checkArgument(isFinish, "pls finish object by call method build() ");
        if(logger.isInfoEnabled()) {
            logger.info(code + ":" + msg, e);
        }
    }

    /**
     * 记录错误编码
     * 
     * @param code 编码
     * @param msg 内容
     */
    public void error(String code, String msg) {

        Preconditions.checkArgument(isFinish, "pls finish object by call method build() ");
        if(logger.isInfoEnabled()) {
            logger.info(code + ":" + msg);
        }
    }

}
