package cn.com.duiba.wolf.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * Created by zzy on 2018/1/19.
 */
public final class GZIPUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GZIPUtils.class);

    private GZIPUtils() {
    }

    /**
     * 压缩字符串
     *
     * @param src
     * @return
     */
    public static byte[] gzip(String src) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream)) {
            gzipOutputStream.write(src.getBytes("utf-8"));
            gzipOutputStream.flush();
            gzipOutputStream.close();
            return outputStream.toByteArray();
        } catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }

    /**
     * 解压缩
     *
     * @param bytes
     * @return
     */
    public static String ungzip(byte[] bytes) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
             GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
             InputStreamReader inputStreamReader = new InputStreamReader(gzipInputStream, "utf-8");
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader)) {
            StringBuilder builder = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            bufferedReader.close();
            return builder.toString();
        } catch (Exception e) {
            LOG.error("", e);
            return null;
        }
    }


//    public static void main(String[] args) throws Throwable {
//        String src = "hellhello worhello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!ldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!o worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!hello worldxxhello worldxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx!";
//        byte[] unziped = src.getBytes("utf-8");
//        byte[] bytes = gzip(src);
//        System.out.println("unzip:" + unziped.length);
//        System.out.println("zip:" + bytes.length);
//        System.out.println(new String(Hex.encodeHex(bytes)));
//        System.out.println(ungzip(bytes));
//    }
}
