/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorEqualsUtils {
    private static final Logger logger = LoggerFactory.getLogger(MirrorEqualsUtils.class);

    public static boolean mirrorEquals(Object source, Object target) {
        if (source == null || target == null) {
            return false;
        }
        boolean rv = true;
        rv = source instanceof Map ? MirrorEqualsUtils.mapOfSrc(source, target, rv) : MirrorEqualsUtils.classOfSrc(source, target, rv);
        return rv;
    }

    private static boolean mapOfSrc(Object source, Object target, boolean rv) {
        boolean result = rv;
        HashMap map = (HashMap)source;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (target instanceof Map) {
                HashMap tarMap = (HashMap)target;
                if (tarMap.get(key) != null && value.equals(tarMap.get(key))) continue;
                result = false;
                break;
            }
            Object tarObj = MirrorEqualsUtils.getClassValue(target, key);
            String tarValue = tarObj == null ? "" : tarObj.toString();
            if (tarValue.equals(value)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean classOfSrc(Object source, Object target, boolean rv) {
        Field[] fields;
        boolean result = rv;
        Class<?> srcClass = source.getClass();
        for (Field field : fields = srcClass.getDeclaredFields()) {
            String tarValue;
            String nameKey = field.getName();
            if (target instanceof Map) {
                String srcValue;
                HashMap tarMap = (HashMap)target;
                Object srcObj = MirrorEqualsUtils.getClassValue(source, nameKey);
                String string = srcValue = srcObj == null ? "" : srcObj.toString();
                if (tarMap.get(nameKey) != null && ((String)tarMap.get(nameKey)).equals(srcValue)) continue;
                result = false;
                break;
            }
            Object srcObj = MirrorEqualsUtils.getClassValue(source, nameKey);
            String srcValue = srcObj == null ? "" : srcObj.toString();
            Object tarObj = MirrorEqualsUtils.getClassValue(target, nameKey);
            String string = tarValue = tarObj == null ? "" : tarObj.toString();
            if (srcValue.equals(tarValue)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Object getClassValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        try {
            Class<?> beanClass = obj.getClass();
            Method[] ms = beanClass.getMethods();
            for (int i = 0; i < ms.length; ++i) {
                String methodName = ms[i].getName();
                if (!methodName.startsWith("get") || !methodName.equalsIgnoreCase(fieldName) && !methodName.substring(3).equalsIgnoreCase(fieldName) && (!"SID".equalsIgnoreCase(fieldName) || !"getId".equalsIgnoreCase(methodName))) continue;
                try {
                    Object objValue = ms[i].invoke(obj, new Object[0]);
                    if (objValue == null) continue;
                    return objValue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.info("\u53d6\u65b9\u6cd5\u51fa\u9519\uff01", (Throwable)e);
        }
        return null;
    }
}

