package cn.com.duiba.wolf.perf;

import java.util.concurrent.atomic.AtomicLong;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

/**
 * Created by xuezhaoming on 16/5/31. <br/>
 * 性能测试采集器
 */
public class PerfCollector {

    // 测试开始时间
    private long                  startTime;

    // 测试结束时间
    private long                  endTime;

    // 成功次数
    private AtomicLong            successCount = new AtomicLong();

    // 失败次数
    private AtomicLong            failCount    = new AtomicLong();

    // 保留所有的结果

    private DescriptiveStatistics result       = new DescriptiveStatistics();

    public void addValue(long value) {
        result.addValue(value);
    }

    public void addSuccess() {
        successCount.incrementAndGet();
    }

    public void addFail() {
        failCount.incrementAndGet();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * 返回运行结果
     *
     * @return 运行结果
     */
    public PerfResult compute() {

        PerfResult perfResult = new PerfResult();

        perfResult.setMin(result.getMin());
        perfResult.setMax(result.getMax());
        perfResult.setAvg(result.getSum() / result.getN());
        perfResult.setSuccessCount(successCount.longValue());
        perfResult.setFailCount(failCount.longValue());
        perfResult.setMedian(median());
        perfResult.setPercent90(result.getPercentile(90));
        perfResult.setPercent95(result.getPercentile(95));
        perfResult.setSkewness(result.getSkewness());
        long costTime = (endTime - startTime) / 1000;
        long count = successCount.longValue() + failCount.longValue();
        double tps = costTime == 0 ? count : count / costTime;
        perfResult.setTps(tps);

        return perfResult;
    }

    public double median() {

        double[] sortedValues = result.getSortedValues();
        int length = sortedValues.length;
        double j = 0;
        if (length % 2 == 0) {
            j = (sortedValues[length / 2] + sortedValues[length / 2 + 1]) / 2;

        } else {
            j = sortedValues[length / 2];
        }

        return j;
    }
}
