/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.redis;

import cn.com.duiba.wolf.log.DegradeLogger;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.com.duiba.wolf.utils.CatUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.Expiration;

public class RedisAtomicClient {
    private static final Logger logger = DegradeLogger.wrap(LoggerFactory.getLogger(RedisAtomicClient.class));
    private final StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
    private static final String INCR_BY_WITH_TIMEOUT = "local v; v = redis.call('incrBy',KEYS[1],ARGV[1]);if tonumber(v) == tonumber(ARGV[1]) then\n    redis.call('expire',KEYS[1],ARGV[2])\nend\nreturn v";
    private static final String COMPARE_AND_DELETE = "if redis.call('get',KEYS[1]) == ARGV[1]\nthen\n    return redis.call('del',KEYS[1])\nelse\n    return 0\nend";

    public RedisAtomicClient(RedisTemplate redisTemplate) {
        this.stringRedisTemplate.setConnectionFactory(redisTemplate.getConnectionFactory());
        this.stringRedisTemplate.afterPropertiesSet();
    }

    public Long getLong(String key) {
        try {
            String val = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (val == null) {
                return null;
            }
            return Long.valueOf(val);
        }
        catch (Exception e) {
            logger.error("get key error:" + key, (Throwable)e);
            CatUtils.logError(e);
            return null;
        }
    }

    public Long incrBy(String key, long delta, long timeout, TimeUnit timeUnit) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        long timeoutSeconds = TimeUnit.SECONDS.convert(timeout, timeUnit);
        Object[] args = new String[]{String.valueOf(delta), String.valueOf(timeoutSeconds)};
        Object currentVal = this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(INCR_BY_WITH_TIMEOUT, Long.class), keys, args);
        if (currentVal instanceof Long) {
            return (Long)currentVal;
        }
        return Long.valueOf((String)currentVal);
    }

    public RedisLock getLock(String key, long expireSeconds) {
        return this.getLock(key, expireSeconds, 0, 0L);
    }

    public RedisLock getLock(String key, long expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis) {
        String value = UUIDUtils.createUUID();
        int maxTimes = maxRetryTimes + 1;
        for (int i = 0; i < maxTimes; ++i) {
            Boolean status = (Boolean)this.stringRedisTemplate.execute(connection -> this.setNx(connection, key, value, expireSeconds));
            if (status != null && status.booleanValue()) {
                return new RedisLockInner(this.stringRedisTemplate, key, value);
            }
            if (retryIntervalTimeMillis > 0L) {
                try {
                    Thread.sleep(retryIntervalTimeMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
        return null;
    }

    private Boolean setNx(RedisConnection connection, String key, String value, long expireSeconds) {
        return connection.set(key.getBytes(), value.getBytes(), Expiration.seconds((long)expireSeconds), RedisStringCommands.SetOption.ifAbsent());
    }

    private class RedisLockInner
    implements RedisLock {
        private StringRedisTemplate stringRedisTemplate;
        private String key;
        private String expectedValue;
        private long threadId;

        protected RedisLockInner(StringRedisTemplate stringRedisTemplate, String key, String expectedValue) {
            this.stringRedisTemplate = stringRedisTemplate;
            this.key = key;
            this.expectedValue = expectedValue;
            this.threadId = Thread.currentThread().getId();
        }

        @Override
        public void unlock() {
            if (Thread.currentThread().getId() != this.threadId) {
                throw new IllegalMonitorStateException();
            }
            List<String> keys = Collections.singletonList(this.key);
            this.stringRedisTemplate.execute((RedisScript)new DefaultRedisScript(RedisAtomicClient.COMPARE_AND_DELETE, Long.class), keys, new Object[]{this.expectedValue});
        }

        @Override
        public void close() throws Exception {
            this.unlock();
        }
    }
}

