package cn.com.duiba.wolf.utils;

/**
 * 二进制开关工具类,把int或者long转为二进制，通过设置第几位为1/0来表示打开/关闭某特性。
 * Created by huangwenqi on 2017/4/20.
 */
public class SwitchUtils {
    /**
     * 判断给定开关集合中是否包含给定binarySwitchLocation(即switches转为二进制后从右数第binarySwitchLocation位是不是为1)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-31
     * @return
     */
    public static boolean switchIsOpen(Integer switches, Integer binarySwitchLocation){
        if(switches == null || binarySwitchLocation == null){
            return false;
        }
        validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        int ret = switches & v;
        return ret != 0;
    }

    /**
     * 判断给定开关集合中是否包含给定binarySwitchLocation(即switches转为二进制后从右数第binarySwitchLocation位是不是为1)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-63
     * @return
     */
    public static boolean switchIsOpen(Long switches, Integer binarySwitchLocation){
        if(switches == null || binarySwitchLocation == null){
            return false;
        }
        validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1L << binarySwitchLocation;
        long ret = switches & v;
        return ret != 0;
    }

    /**
     * 在开关集合中打开binarySwitchLocation指定的开关(即switches转为二进制后把从右数第binarySwitchLocation位转为1)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-31
     * @return
     */
    public static Integer openSwitch(Integer switches, Integer binarySwitchLocation){
        if(switches == null){
            switches = 0;
        }
        if(binarySwitchLocation == null){
            return switches;
        }
        validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        return switches | v;
    }

    /**
     * 在开关集合中打开binarySwitchLocation指定的开关(即switches转为二进制后把从右数第binarySwitchLocation位转为1)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-63
     * @return
     */
    public static Long openSwitch(Long switches, Integer binarySwitchLocation){
        if(switches == null){
            switches = 0L;
        }
        if(binarySwitchLocation == null){
            return switches;
        }
        validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1L << binarySwitchLocation;
        return switches | v;
    }

    /**
     * 在开关集合中关闭binarySwitchLocation指定的开关(即switches转为二进制后把从右数第binarySwitchLocation位转为0)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-31
     * @return
     */
    public static Integer closeSwitch(Integer switches, Integer binarySwitchLocation){
        if(switches == null){
            switches = 0;
        }
        if(binarySwitchLocation == null){
            return switches;
        }
        validateBinarySwitchLocationInteger(binarySwitchLocation);
        int v = 1 << binarySwitchLocation;
        return switches & (~v);
    }

    /**
     * 在开关集合中关闭binarySwitchLocation指定的开关(即switches转为二进制后把从右数第binarySwitchLocation位转为0)
     * @param switches
     * @param binarySwitchLocation 二进制数从右边数起的位置,取值范围0-63
     * @return
     */
    public static Long closeSwitch(Long switches, Integer binarySwitchLocation){
        if(switches == null){
            switches = 0L;
        }
        if(binarySwitchLocation == null){
            return switches;
        }
        validateBinarySwitchLocationLong(binarySwitchLocation);
        long v = 1 << binarySwitchLocation;
        return switches & (~v);
    }

    private static void validateBinarySwitchLocationLong(Integer binarySwitchLocation){
        if(binarySwitchLocation < 0 || binarySwitchLocation > 63){
            throw new IllegalArgumentException("arg[binarySwitchLocation] must between 0 and 63");
        }
    }

    private static void validateBinarySwitchLocationInteger(Integer binarySwitchLocation){
        if(binarySwitchLocation < 0 || binarySwitchLocation > 31){
            throw new IllegalArgumentException("arg[binarySwitchLocation] must between 0 and 31");
        }
    }

}
