package cn.com.duiba.wolf.dubbo;

/**
 * dubbo 异常,包含精简版的异常堆栈。只保留每个cause by 的前两句
 * Created by wenqi.huang on 16/6/14.
 */
public class DubboException extends RuntimeException {

    static final long serialVersionUID = -703231971907457639L;

    private final int errorCode;//错误代码
    private final String stackTraceStr;//精简版的异常堆栈字符串。只保留每个cause by 的前两句

    public DubboException(String message, String stackTraceStr){
        super(message);
        this.errorCode = 0;
        this.stackTraceStr = stackTraceStr;
    }

    public DubboException(int errorCode, String message, String stackTraceStr){
        super(message);
        this.errorCode = errorCode;
        this.stackTraceStr = stackTraceStr;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public String getStackTraceStr() {
        return stackTraceStr;
    }
}
