package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.service.exception.ServiceInternalException;

import java.io.Serializable;

/**
 * Created by xuezhaoming on 16/5/5. </br> dubbo 调用统一返回结果对象
 * 已废弃，请直接返回要返回的对象
 */
@Deprecated
public class DubboResult<T> implements Serializable {

    private static final long serialVersionUID = -6978963188996203322L;

    private static final String CODE_SERVICE_INTERNAL_EXCEPTION = "0102";

    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";

    // 调用是否成功
    private boolean isSuccess = true;

    // 调用结果信息,可以放异常的message.
    private String msg;

    // 返回码
    private String returnCode;

    // 调用结果
    private T result;

    /**
     * 快速构建成功返回对象
     *
     * @param result 返回结果
     * @return
     */
    public static <T> DubboResult<T> successResult(T result) {
        DubboResult dubboResult = new DubboResult();
        dubboResult.setResult(result);
        dubboResult.setSuccess(true);
        dubboResult.setMsg(SUCCESS);
        return dubboResult;
    }

    /**
     * 快速构建失败返回对象
     *
     * @param msg 失败信息
     * @param <T>
     * @return
     */
    public static <T> DubboResult<T> failResult(String msg) {
        DubboResult dubboResult = new DubboResult();
        dubboResult.setSuccess(false);
        dubboResult.setMsg(msg);
        return dubboResult;
    }

    public DubboResult() {
    }

    public DubboResult(boolean isSuccess, String msg, T result) {
        this.isSuccess = isSuccess;
        this.msg = msg;
        this.result = result;
    }

    public static DubboResult builder() {
        return new DubboResult();
    }

    public DubboResult isSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
        return this;
    }

    public DubboResult msg(String msg) {
        this.msg = msg;
        return this;
    }

    public DubboResult result(T result) {
        this.result = result;
        return this;
    }

    public DubboResult build() {
        return this;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 获取结果,在调用这个方法之前,你应该始终先调用isSuccess()判断是否成功,如果调用失败了,不应该调用此方法
     *
     * @return
     */
    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public static void main(String[] args) {

        DubboResult<String> dubboResult = mockDubboResult();

        if (dubboResult.isSuccess()) {
            // todo
        } else {
            // todo
        }
    }

    private static DubboResult<String> mockDubboResult() {
        return new DubboResult<String>();
    }
}
