/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UrlUtils2 {
    public static Map<String, String> extractUrlParamsFromUrl(String url) {
        String strUrlParam = UrlUtils2.truncateUrlPage(url);
        if (strUrlParam == null) {
            return Collections.emptyMap();
        }
        return UrlUtils2.extractUrlParams(strUrlParam);
    }

    public static Map<String, String> extractUrlParams(String paramsStr) {
        String[] arrSplit;
        if (StringUtils.isBlank((String)paramsStr)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        for (String strSplit : arrSplit = StringUtils.split((String)paramsStr, (char)'&')) {
            String[] arrSplitEqual = StringUtils.split((String)strSplit, (char)'=');
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0].equals("")) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public static String buildUrlParams(Map<String, String> params) {
        if (Objects.equal(null, params) || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static String truncateUrlPage(String strURL) {
        String url = StringUtils.trimToEmpty((String)strURL);
        int idx = url.indexOf(63);
        if (idx == -1) {
            return null;
        }
        return url.substring(idx + 1);
    }

    public static String extractUrl(String strUrl) {
        if (StringUtils.isBlank((String)strUrl)) {
            return null;
        }
        String url = StringUtils.trimToEmpty((String)strUrl);
        int idx = url.indexOf(63);
        if (idx == -1) {
            return null;
        }
        return url.substring(0, idx);
    }

    public static String appendParams(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(url);
        if (sb.indexOf("?") != -1) {
            sb.append("&");
            sb.append(UrlUtils2.buildUrlParams(params));
        } else {
            sb.append("?");
            sb.append(UrlUtils2.buildUrlParams(params));
        }
        return sb.toString();
    }
}

