package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 审批节点类型
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AuditNodeEnum.java , v 0.1 2020-03-19 4:56 下午 ZhouFeng Exp $
 */
@AllArgsConstructor
@Getter
public enum AuditNodeEnum {

    /**
     * QA人员
     */
    QA(1, "QA人员"),

    /**
     * 相关测试
     */
    TESTER(2, "相关测试"),

    /**
     * 相关运营
     */
    OPERATOR(3, "相关运营"),
    ;

    private int type;
    private String name;

    private static Map<Integer, AuditNodeEnum> CACHE =
            Arrays.stream(AuditNodeEnum.values()).collect(Collectors.toMap(AuditNodeEnum::getType,
                    Function.identity()));

    public static AuditNodeEnum of(int type) {
        return CACHE.get(type);
    }

}
