package cn.com.duiba.wooden.kite.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wooden.kite.service.api.dto.ProjectActionCardAlarmParams;
import cn.com.duiba.wooden.kite.service.api.dto.ProjectxAlarmParamsDto;

/**
 * 星速台项目钉钉告警接口
 *
 * @author fxr
 * @date 2020-6-1
 */
@AdvancedFeignClient
public interface RemoteProjectxAlarmService {
    /**
     * 发送报警信息
     *
     * @param alarmParams 报警参数对象
     */
    void sendAlarmMessage(ProjectxAlarmParamsDto alarmParams);

    /**
     * 发送通用报警信息
     * - 通过工作通知(卡片类型)
     *
     * @param alarmParams 报警参数对象
     * @desc ⚠️
     * 同一个应用相同消息的内容同一个用户一天只能接收一次。
     * 同一个应用给同一个用户发送消息，企业内部应用一天不得超过500次。
     * 通过设置to_all_user参数全员推送消息，一天最多3次。
     * 超出以上限制次数后，接口返回成功，但用户无法接收到。详细的限制说明，请参考工作通知消息限制。
     * 该接口是异步发送消息，接口返回成功并不表示用户一定会收到消息
     * @see <a href="https://developers.dingtalk.com/document/app/asynchronous-sending-of-enterprise-session-messages">详见</a>
     */
    void sendAlarmMessageByActionCard(ProjectActionCardAlarmParams alarmParams);
}
