package cn.com.duiba.wooden.kite.service.api.dto;


import cn.com.duiba.wooden.kite.service.api.enums.AlarmMsgReceiverTypeEnum;
import cn.com.duiba.wooden.kite.service.api.enums.AlarmMsgTypeEnum;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 星速台项目钉钉告警接口参数类
 *
 * @author fxr
 * @date 2020-6-1
 */
public class ProjectxAlarmParamsDto implements Serializable {
    private static final long serialVersionUID = -6951652181725207315L;

    /**
     * 告警消息类型
     *
     * @see AlarmMsgTypeEnum#getCode()
     */
    @NotNull(message = "告警消息类型不能为空")
    private Integer msgType;

    /**
     * 星速台项目id
     */
    @NotNull(message = "星速台项目id不能为空")
    private String projectId;

    /**
     * 星速台项目钉钉告警对象/告警消息接受对象群体类型
     *
     * @see AlarmMsgReceiverTypeEnum#getCode()
     */
    @NotNull(message = "告警消息接受对象群体类型不能为空")
    private List<Integer> msgReceiverTypeList;

    /**
     * 告警消息标题
     */
    @NotNull(message = "消息标题不能为空")
    private String msgTitle;

    /**
     * 告警消息内容
     */
    @NotNull(message = "消息内容不能为空")
    private String msg;

    /**
     * 告警消息业务标识
     * 此标识用于告警消息限流，同一个项目内需保证此字段针对不同的告警消息类型，具有不同的业务标识
     */
    @NotNull(message = "消息业务标识不能为空")
    private String msgBizCode;

    /**
     * 机器人id
     */
    private Long robotId;

    /**
     * 是否at全部人
     */
    private Boolean isAtAll = false;

    public Integer getMsgType() {
        return msgType;
    }

    public ProjectxAlarmParamsDto setMsgType(Integer msgType) {
        this.msgType = msgType;
        return this;
    }

    public String getProjectId() {
        return projectId;
    }

    public ProjectxAlarmParamsDto setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getMsg() {
        return msg;
    }

    public ProjectxAlarmParamsDto setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public String getMsgBizCode() {
        return msgBizCode;
    }

    public ProjectxAlarmParamsDto setMsgBizCode(String msgBizCode) {
        this.msgBizCode = msgBizCode;
        return this;
    }

    public Long getRobotId() {
        return robotId;
    }

    public ProjectxAlarmParamsDto setRobotId(Long robotId) {
        this.robotId = robotId;
        return this;
    }

    public Boolean getIsAtAll() {
        return isAtAll;
    }

    public ProjectxAlarmParamsDto setIsAtAll(Boolean isAtAll) {
        this.isAtAll = isAtAll;
        return this;
    }

    public String getMsgTitle() {
        return msgTitle;
    }

    public ProjectxAlarmParamsDto setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
        return this;
    }

    public List<Integer> getMsgReceiverTypeList() {
        return msgReceiverTypeList;
    }

    public ProjectxAlarmParamsDto setMsgReceiverTypeList(List<Integer> msgReceiverTypeList) {
        this.msgReceiverTypeList = msgReceiverTypeList;
        return this;
    }
}