package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工单审批类型
 */
@AllArgsConstructor
@Getter
public enum CommonWorkflowTypeEnum {

    /**
     * 星速台奖品补发
     */
    PROJECT_PRIZE_REISSUE(1),

    /**
     * app免登生成
     */
    APP_FREE_LOGIN(2),


    ;

    private int code;

    private static Map<Integer, CommonWorkflowTypeEnum> CACHE =
            Arrays.stream(CommonWorkflowTypeEnum.values()).collect(Collectors.toMap(CommonWorkflowTypeEnum::getCode,
                    Function.identity()));

    public static CommonWorkflowTypeEnum of(int code) {
        return CACHE.get(code);
    }

}
