package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工单状态
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WorkflowStatusEnum.java , v 0.1 2020-03-19 4:00 下午 ZhouFeng Exp $
 */
@AllArgsConstructor
@Getter
public enum WorkflowStatusEnum {

    /**
     * 初始状态
     */
    INITIAL(1),

    /**
     * 预检查通过
     */
    PRE_CHECK_PASS(2),

    /**
     * 待审核
     */
    CHECK_PENDING(3),


    /**
     * 审核通过
     */
    PASS(4),

    /**
     * 审核拒绝
     */
    REJECT(5),

    /**
     * 完结
     */
    FINISH(6),

    /**
     * 撤销
     */
    CANCLE(7),


    /**
     * 成功
     */
    SUCCESS(8),

    /**
     * 失败
     */
    FAIL(9),

    /**
     * 构建中
     */
    BUILDING(10),

    /**
     * 未修改
     */
    NONE(11)

    ;

    private int code;

    private static Map<Integer, WorkflowStatusEnum> CACHE =
            Arrays.stream(WorkflowStatusEnum.values()).collect(Collectors.toMap(WorkflowStatusEnum::getCode,
                    Function.identity()));

    public static WorkflowStatusEnum of(int code) {
        return CACHE.get(code);
    }



    private static final List<Integer> SUCCESS_IS_OVER =Arrays.asList(CommonWorkflowTypeEnum.APP_FREE_LOGIN.getCode(),CommonWorkflowTypeEnum.PROJECT_PRIZE_REISSUE.getCode());

    /**
     * 成功即完结的任务
     * @param code
     * @return
     */
    public static boolean successIsOver(Integer code) {

        return SUCCESS_IS_OVER.contains(code);
    }

}
