package cn.com.duiba.wooden.kite.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 审核节点
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AuditDto.java , v 0.1 2020-03-19 5:00 下午 ZhouFeng Exp $
 */
@Data
public class AuditDto implements Serializable {
    private static final long serialVersionUID = -8523130282586939619L;

    /**
     * 节点类型
     *
     * @see cn.com.duiba.wooden.kite.service.api.enums.AuditNodeEnum
     */
    private Integer type;

    /**
     * 指派用户id
     */
    private List<Long> assignToUserIds;

    /**
     * 节点名称
     */
    private String nodeName;

    /**
     * 节点状态
     *
     * @see cn.com.duiba.wooden.kite.service.api.enums.AuditStatusEnum
     */
    private Integer nodeStatus;
    /**
     * 操作评论
     */
    private String operComment;
    /**
     * 操作用户id
     */
    private Long operUserId;
    /**
     * 操作用户姓名
     */
    private String operUserName;
    /**
     * 操作时间
     */
    private Date operTime;

}
