package cn.com.duiba.wooden.kite.service.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 星速台项目钉钉告警方式
 *
 * @author fxr
 * @date 2020-6-8
 */
public enum AlarmMsgTypeEnum {

    /**
     * 群消息告警
     */
    GROUP_MESSAGE(1, "群消息告警"),
    /**
     * 普通工作消息告警
     */
    NORMAL_WORK_MESSAGE(2, "普通工作消息告警");

    /**
     * code
     */
    private Integer code;
    /**
     * 描述
     */
    private String desc;

    AlarmMsgTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, AlarmMsgTypeEnum> CACHE = Arrays.stream(AlarmMsgTypeEnum.values())
            .collect(Collectors.toMap(AlarmMsgTypeEnum::getCode, Function.identity()));

    public static AlarmMsgTypeEnum of(int code) {
        return CACHE.get(code);
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
