package cn.com.duiba.wooden.kite.service.api.dto;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @program: wood-kite-service
 * @description: 星速台卡片格式告警通知参数
 * @author: Simba
 * @create: 2021-04-17 10:00
 **/
public class ProjectActionCardAlarmParams implements Serializable {

    /**
     * 星速台项目id
     */
    @NotNull(message = "星速台项目id不能为空")
    private String projectId;

    /**
     * 星速台项目名称
     */
    private String projectName;

    /**
     * 星速台项目钉钉告警对象 sso admin userId
     */
    @NotNull(message = "告警消息接受对象群体管理员id不能为空")
    private List<Long> adminIdList;

    /**
     * 告警消息标题
     * 用于 首屏 标题展示
     */
    @NotNull(message = "首屏标题不能为空")
    private String screenTitle;

    /**
     * 告警消息标题
     * 用于 卡片头 展示
     *
     * @desc "星速台{xxx}预警" ，该字段用于反填中间部分
     */
    private String cardTitle;

    /**
     * 告警消息内容
     */
    @NotNull(message = "消息内容不能为空")
    private String msg;

    /**
     * 告警消息业务标识
     * 此标识用于告警消息限流，同一个项目内需保证此字段针对不同的告警消息类型，具有不同的业务标识
     */
    @NotNull(message = "消息业务标识不能为空")
    private String msgBizCode;

    /**
     * 告警消息跳转按钮文案
     */
    private String linkText;

    /**
     * 告警消息跳转链接
     */
    private String linkUrl;

    /**
     * 是否at全部人
     */
    private Boolean atAll = false;

    /**
     * link 打开方式在PC端侧边栏打开 or 浏览器打开
     */
    private Boolean openWayPcSide = false;

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List<Long> getAdminIdList() {
        return adminIdList;
    }

    public void setAdminIdList(List<Long> adminIdList) {
        this.adminIdList = adminIdList;
    }

    public String getScreenTitle() {
        return screenTitle;
    }

    public void setScreenTitle(String screenTitle) {
        this.screenTitle = screenTitle;
    }

    public String getCardTitle() {
        return cardTitle;
    }

    public void setCardTitle(String cardTitle) {
        this.cardTitle = cardTitle;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getMsgBizCode() {
        return msgBizCode;
    }

    public void setMsgBizCode(String msgBizCode) {
        this.msgBizCode = msgBizCode;
    }

    public String getLinkText() {
        return linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Boolean getAtAll() {
        return atAll;
    }

    public void setAtAll(Boolean atAll) {
        this.atAll = atAll;
    }

    public Boolean getOpenWayPcSide() {
        return openWayPcSide;
    }

    public void setOpenWayPcSide(Boolean openWayPcSide) {
        this.openWayPcSide = openWayPcSide;
    }
}