package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 节点审核状态
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WorkflowStatusEnum.java , v 0.1 2020-03-19 4:00 下午 ZhouFeng Exp $
 */
@AllArgsConstructor
@Getter
public enum AuditStatusEnum {

    /**
     * 初始状态
     */
    INITIAL(1),

    /**
     * 待审核
     */
    CHECK_PENDING(2),


    /**
     * 审核通过
     */
    PASS(3),

    /**
     * 审核拒绝
     */
    REJECT(4),
    ;

    private int code;


}
