package cn.com.duiba.wooden.kite.service.api.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author czw
 */
@Data
public class WorkOpenGrayWhiteListDto implements Serializable {
    /**
     * 项目名称
     */
    @NotNull
    private String projectName;
    /**
     * 项目ID
     */
    @NotNull
    private String projectId;

    /**
     * 灰度项目
     */
    private String garyProjectId;
    /**
     * APPId
     */
    @NotNull
    private String appId;

    /**
     * 是否是灰度测试项目
     */
    private Integer bizType;
    /**
     * 备注信息
     */
    private String remark;
    /**
     * 申请人
     */
    private Long createUserId;
    /**
     * 申请人姓名
     */
    private String createUserName;
    /**
     * 审核人员
     */
    private List<Long> checkUserIds;
    /**
     * app来源:
     * projectx
     * A
     * B
     */
    private String fromApp;

    /**
     * 业务id
     */
    private String commonId;
}
