package cn.com.duiba.wooden.kite.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 工单申请参数
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WorkflowDto.java , v 0.1 2020-03-19 3:56 下午 ZhouFeng Exp $
 */
@Data
public class WorkflowApplyDto implements Serializable {

    private static final long serialVersionUID = 1418952003805618622L;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 工单状态
     *
     * @see cn.com.duiba.wooden.kite.service.api.enums.WorkflowStatusEnum
     */
    private Integer workflowStatus;
    /**
     * 基本信息
     */
    private String basicInfo;
    /**
     * 项目配置
     */
    private String attributes;
    /**
     * 更新前的基本信息
     */
    private String currentBasicInfo;
    /**
     * 更新前的项目配置
     */
    private String currentAttributes;
    /**
     * 创建用户id
     */
    private Long createUserId;

    /**
     * 发起人身份 1：开发 2：运营
     */
    private Integer initiator;
    /**
     * 创建用户姓名
     */
    private String createUserName;

    /**
     * 审批节点
     */
    private List<AuditDto> auditNodes;

    /**
     * 执行方式
     *
     * @see cn.com.duiba.wooden.kite.service.api.enums.WorkflowExecuteEnum
     */
    private Integer executeType;

    /**
     * 代码地址
     */
    private String codeUrl;

    /**
     * js白名单配置
     */
    private String jsWhiteConfig;

    /**
     * 备注
     */
    private String remarks;
    /**
     * 发布类型:默认1
     * 线上问题修复 2
     * 需求迭代 3
     * 日志相关修改 4
     * 配合测试修改 5
     * 配置项修改 6
     */
    private Integer publishType;
}
