package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 发布类型
 *
 * @author houjx houjiaxu@duiba.com.cn
 */
@AllArgsConstructor
@Getter
public enum WorkflowPublishTypeEnum {

    /**
     * 默认值
     */
    DEFAULT(1,"默认"),

    /**
     * bug修复
     */
    BUG_REPAIR(2,"问题修复"),

    /**
     * 功能迭代
     */
    FUNCTION_ITERATION(3,"需求迭代"),

    LOG_UPDATE(4,"日志相关修改"),

    TEST_UPDATE(5,"配合测试修改"),

    CONFIG_UPDATE(6,"配置项修改"),


    ;

    private int code;
    private String type;

    public static WorkflowPublishTypeEnum getEnumByCode(Integer code) {
        for (WorkflowPublishTypeEnum publishTypeEnum : WorkflowPublishTypeEnum.values()) {
            if(publishTypeEnum.getCode() == code.intValue()){
                return publishTypeEnum;
            }
        }
        return null;
    }

}
