package cn.com.duiba.wooden.kite.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wooden.kite.service.api.dto.AuditOperateDto;
import cn.com.duiba.wooden.kite.service.api.dto.CustomerLinkFlowDTO;
import cn.com.duiba.wooden.kite.service.api.dto.PageResult;
import cn.com.duiba.wooden.kite.service.api.dto.RevocationWorkDto;
import cn.com.duiba.wooden.kite.service.api.dto.StopWorkflowDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkFlowFreeLoginDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkFlowQueryDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkFlowReissuePrizeDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkGrayWhiteListDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkOpenGrayWhiteListDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkflowApplyDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkflowCommonInfoDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkflowDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkflowInfoDto;
import cn.com.duiba.wooden.kite.service.api.dto.WorkFlowDomainInfoDto;
import cn.com.duiba.wooden.kite.service.api.enums.CommonWorkflowTypeEnum;

import java.util.List;

/**
 * 工作流（工单）服务
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteWorkflowService.java , v 0.1 2020-03-19 3:54 下午 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteWorkflowService {

    /**
     * 创建工单申请
     *
     * @param applyDto
     * @return
     */
    long apply(WorkflowApplyDto applyDto) throws BizException;


    /**
     * 审批（包括执行发布)
     *
     * @param operate
     */
    void audit(AuditOperateDto operate) throws BizException;


    /**
     * 查询工单
     *
     * @param id
     * @return
     */
    WorkflowDto queryById(Long id);


    /**
     * 查询项目的所有工单
     *
     * @param projectId
     * @return
     */
    List<WorkflowInfoDto> queryByProjectId(String projectId);

    /**
     * 翻页查询工单
     *
     * @param projectId
     * @return
     */
    PageResult<WorkflowInfoDto> pageQueryByProjectId(String projectId, long page, long rows);

    /**
     * 修改工单发布状态
     */
    void updateState(Long workflowId, int field, int state);

    /**
     * 根据状态查询项目的工单
     *
     * @param projectId
     * @return
     */
    List<WorkflowInfoDto> queryByProjectIdUnfinish(String projectId);

    /**
     * 终止工单流程，重新审核
     *
     * @desc 由于钉钉有一定几率在审批完成后，出现推送"发布"通知失败的情况，虽然几率很低（星速台上线以来出现十次之内），
     * 但一旦出现，致使生产单项目发布流程卡单，在联系不到人的情况下，活动开发无法自主处理，可能会导致问题严重化
     * 故增加终止流程操作，在卡单情况下可以临时终止进行重新提交审批
     * 终止流程基准条件：
     * 1、工单已经审核通过
     * 2、工单没有处于发布过程中
     * 3、发起"终止"人员与发起"审核"人员需是同一个人
     * 4、2分钟之后依然没有推送"发布"工单 (暂定三分钟，具体时间后续可通过修改 CommConfiguration 中的配置修改)
     */
    boolean stopWorkflow(StopWorkflowDto stopWorkflowDto) throws BizException;


    /**
     * 创建工单申请(兑吧管理后台使用)
     * 由运营发起，到运营主管审批
     * @return 工作流id
     */
    long createDingDingRepairOrder(WorkFlowDomainInfoDto workFlowDomainInfoDto) throws BizException;




    /**
     * 创建奖品补发工单
     *
     * @return 工作流id
     */
    long createReissuePrize(WorkFlowReissuePrizeDto workFlowReissuePrizeDto) throws BizException;


    /**
     * 创建免登申请链接申请
     * @param workFlowFreeLoginDto
     * @return
     * @throws BizException
     */
    long createAppFreeLoginFlow(WorkFlowFreeLoginDto workFlowFreeLoginDto) throws BizException;


    /**
     * 创建三方接口审批
     * @param customerLinkFlowDTO
     * @return
     * @throws BizException
     */
    Long createCustomerLinkFlow(CustomerLinkFlowDTO customerLinkFlowDTO) ;


    /**
     * 开始时间之后 是否有通过的记录
     * @param commonId
     * @param createUserId
     * @param commonWorkflowTypeEnum
     * @param startTime
     * @return
     */
    boolean haveCommonPassRecord(String commonId, Long createUserId, CommonWorkflowTypeEnum commonWorkflowTypeEnum, Long startTime);


    /**
     * 翻页查询工单
     *
     * @param dto
     * @return
     */
    PageResult<WorkflowCommonInfoDto> pageQueryCommonByType(WorkFlowQueryDto dto);


    /**
     * 创建灰度白名单
     * @param workGrayWhiteListDto
     * @return
     */
    long createGrayWhiteList(WorkGrayWhiteListDto workGrayWhiteListDto);

    /**
     * 开启灰度白名单
     * @param workOpenGrayWhiteListDto
     * @return
     */
    long createOpenGrayWhiteList(WorkOpenGrayWhiteListDto workOpenGrayWhiteListDto);
    /**
     * 查询通用表单审批流
     * @param id
     * @return
     */
    WorkflowCommonInfoDto queryCommonById(Long id);

    /**
     * 审核工单
     * @param dingId 钉钉工单ID
     * @param pass true 通过 false 拒绝
     * @return
     */
    Boolean auditCommonWork(String dingId, Boolean pass);

    /**
     * 撤销申请
     * @param revocationWorkDto
     * @return
     */
    Boolean revocationApply(RevocationWorkDto revocationWorkDto) throws BizException;

    /**
     * 根据workflow重试
     * @param workFlowId
     * @return
     */
    Boolean rePublish(long workFlowId) throws BizException;
}
