package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * `entity_auth`
 */
@Data
public class EntityAuth implements Serializable {
    @ApiModelProperty("主体实名ID")
    private Long id;

    @ApiModelProperty("签约主体ID")
    private Long signEntityId;

    @ApiModelProperty("个人证件号码（个人属性）")
    private String userIdentity;

    @ApiModelProperty("证件类型（个人属性）")
    private Byte identityType;

    @ApiModelProperty("真实名称（个人姓名/企业名称）")
    private String realName;

    @ApiModelProperty("身份证正面")
    private String idcardFront;

    @ApiModelProperty("身份证反面")
    private String idcardBack;

    @ApiModelProperty("手机号码/账号（个人属性）")
    private String mobile;

    @ApiModelProperty("营业执照（企业属性）")
    private String regCode;

    @ApiModelProperty("税务登记证（企业属性）")
    private String taxCode;

    @ApiModelProperty("组织架构代码（企业属性）")
    private String orgCode;

    @ApiModelProperty("营业执照图片")
    private String regImage;

    @ApiModelProperty("法人（企业属性）")
    private String legalPerson;

    @ApiModelProperty("法人证件信息（企业属性）")
    private String legalPersonIdentity;

    @ApiModelProperty("法人证件类型（企业属性）")
    private Byte legalPersonIdentityType;

    @ApiModelProperty("法人手机号码（企业属性）")
    private String legalPersonMobile;

    @ApiModelProperty("法人身份证正面")
    private String legalIdcardFront;

    @ApiModelProperty("法人身份证反面")
    private String legalIdcardBack;

    @ApiModelProperty("上上签账户")
    private String ssqAccount;

    @ApiModelProperty("证书编号")
    private String certNo;

    @ApiModelProperty("ssq申请证书taskId")
    private String taskId;
}